<?php

/*
Product: 		mh_anolink (Link Anonymizer)
Version:		1.20
Author:			Marco van Herwaarden
vB version:	3.6.x

Nothing in this code can be redistributed or reused with the authors permission.
*/

function mh_anonymize(&$message)
{
	global $vbulletin;
	
	if ($message)
	{
		// If we have a black/whitelist, prepair the list in an array
		$wb_list = array();
		if (trim($vbulletin->options['mh_anolink_whiteblack_list']))
		{
			$wb_list = preg_split('/\s+/', $vbulletin->options['mh_anolink_whiteblack_list'], -1, PREG_SPLIT_NO_EMPTY);
		}
		
		// Do we have links?
		if (preg_match_all("/(\<a href=\")(.*)(\<\/a\>)/i", $message, $matches))
		{
			// Load the list of protocols to be ignored.
			$ignore_protocol = explode(",",str_replace(" ", "", $vbulletin->options['mh_anolink_ignore_protocol']));
			
			// Build local addresses and initialise replace arrays
			$localdomains = ($vbulletin->options['mh_anolink_localaddresses'] ? explode(" ", $vbulletin->options['mh_anolink_localaddresses']) : ($vbulletin->options['cookiedomain'] ? array($vbulletin->options['cookiedomain']) : array($_SERVER['SERVER_NAME'])));
			$preg_search = array();
			$preg_replace = array();
			$wb_list_checked = array();
			
			foreach ($matches[0] AS $key=>$fulllink)
			{
				preg_match("/(\<a href=\")(.[^\"]*)/i", $fulllink, $matches2);
				$serverurl = $matches2[2];
				
				// Do we have a local url?
				$servername = null;
				if (($parsed_url = @parse_url($serverurl)) !== false)
				{
					$servername = $parsed_url['host'];
					
					// Should we skip this link? Either because it is using an ignored protocol, or because it is a local fragment
					if (in_array($parsed_url['scheme'], $ignore_protocol)
							OR ($parsed_url['fragment'] AND !$parsed_url['host']))
					{
						continue;
					}
					
					foreach ($localdomains AS $localdomain)
					{
						if (substr($localdomain, 0, 1) == ".")
						{
							if (preg_match("/$localdomain$/i", $servername))
							{
								continue 2;
							}
						}
						else
						{
							if (strtolower($localdomain) == strtolower($servername))
							{
								continue 2;
							}
						}
					}
				}
				else
				{
					// We got an unparsable url, should we skip anonimysation?
					if (!$vbulletin->options['mh_anolink_anonym_unparseble'])	// oops type, better not change or we will break compatibility with older versions
					{
						continue;
					}
					else
					{
						$servername = null;
					}
				}
				
				// If we have a black/whitelist, check domain (ignore if unparsable)
				if (count($wb_list) > 0 AND $servername)
				{
					$wb_inlist = false;
					foreach ($wb_list AS $wb_list_domain)
					{
						$regex = preg_quote($wb_list_domain, '#$');
			
						if (preg_match("#$regex#i", $servername))
						{
							$wb_inlist = true;
							break;
						}
					}
					
					if (($wb_inlist == true AND $vbulletin->options['mh_anolink_wblist_type'] == 1)			// Black listed
						OR ($wb_inlist == false AND $vbulletin->options['mh_anolink_wblist_type'] == 0)		// Not in Whitelist
						)
					{
						$preg_search["$fulllink"] = $fulllink;
						$preg_replace["$fulllink"] = ($vbulletin->options['mh_anolink_wblist_url'] ? $vbulletin->options['mh_anolink_wblist_url'] : "<a href=\"" . $vbulletin->options['forumhome'] . ".php\">" . $vbulletin->options['bbtitle'] . "</a>");
						
						// Once we have a match, there is no use to anonymize anymore
						continue;
					}
				}
				
				// Yes we need to take action on this URL, add to the replace list.
				$anonymurl = $vbulletin->options['mh_anolink_anonymizer'] . $serverurl;
				$preg_search["$serverurl"] = "<a href=\"$serverurl";
				$preg_replace["$serverurl"] = "<a href=\"" . $anonymurl;
			}

			if ($preg_search)
			{
				$message = str_replace($preg_search, $preg_replace, $message);
			}
		}
	}
}

?>